/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.entities;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.levels.TerrainLevel;

public class Gun
extends Entity {
    Worm worm = null;
    TerrainLevel terrainLevel;
    int bulletTrailTime = 50;
    int timeBetweenShots = 150;
    long lastShot = CrustyEngine.currentTimeMillis();
    Vec2int placeLastShot = new Vec2int(0, 0);
    Vec2int locationAtShot = new Vec2int(0, 0);
    Vec2int shootOffset = new Vec2int(0, -3);
    Vec2int lastMousePos = new Vec2int(0, 0);
    public boolean canShoot = true;
    public boolean canRightClick = false;
    boolean attachedToWorm = false;

    public Gun(Sprite[] sprites, int xoffset, int yoffset, TerrainLevel terrainLevel) {
        super(sprites, xoffset, yoffset);
        this.depth = 6;
        this.terrainLevel = terrainLevel;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        if (CrustyEngine.currentTimeMillis() - this.lastShot < (long)this.bulletTrailTime) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(this.locationAtShot.x, this.locationAtShot.y, this.placeLastShot.x, this.placeLastShot.y);
        }
    }

    public void setWormDontAttach(Worm w) {
        this.worm = w;
    }

    public void setWorm(Worm w) {
        this.worm = w;
        this.attachedToWorm = true;
        this.currentSprite = SpriteManager.getSprite("img/guns/assaultrifle.bmp");
        this.currentImage = this.currentSprite.images[0];
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        if (!this.attachedToWorm) {
            this.offset.y = (int)((Math.sin((float)CrustyEngine.currentTimeMillis() / 150.0f) + 1.0) * 4.0);
            if (this.worm.pos.sub(this.pos).length() < 10.0) {
                this.setWorm(this.worm);
                this.worm.setGun(this);
                SoundManager.playSound("sounds/pump.wav");
            }
        }
        if (this.attachedToWorm && this.worm != null) {
            this.pos.x = this.worm.pos.x;
            this.pos.y = this.worm.pos.y;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.canShoot && this.attachedToWorm && this.worm != null) {
            if (e.getButton() == 1) {
                if (this.worm != null && this.terrainLevel != null && CrustyEngine.currentTimeMillis() - this.lastShot > (long)this.timeBetweenShots) {
                    int blue;
                    int green;
                    int red;
                    Vec2 dir = new Vec2((double)e.getX() - this.pos.x, (double)e.getY() - this.pos.y);
                    dir = dir.normalise();
                    double x = this.pos.x + (double)this.shootOffset.x;
                    double y = this.pos.y + (double)this.shootOffset.y;
                    this.locationAtShot.x = (int)x;
                    this.locationAtShot.y = (int)y;
                    do {
                        y += dir.y;
                        if ((x += dir.x) > (double)this.terrainLevel.getBackground().getWidth() || x < 0.0 || y > (double)this.terrainLevel.getBackground().getHeight() || y < 0.0) {
                            return;
                        }
                        int c = this.terrainLevel.getBackground().getRGB((int)x, (int)y);
                        red = (c & 0xFF0000) >> 16;
                        green = (c & 0xFF00) >> 8;
                        blue = c & 0xFF;
                    } while (red == 0 && green == 0 && blue == 0);
                    int rad = 20;
                    this.terrainLevel.createHole(x, y, rad, this.worm);
                    this.placeLastShot.x = (int)x;
                    this.placeLastShot.y = (int)y;
                    this.lastShot = CrustyEngine.currentTimeMillis();
                    CrustyEngine.getParticleManager().createBurst(6, SpriteManager.getSprite("img/particles/dustcloud.bmp"), new Vec2(x, y));
                }
            } else if (this.canRightClick && e.getButton() == 3 && CrustyEngine.currentTimeMillis() - this.lastShot > (long)this.timeBetweenShots) {
                int blue;
                int green;
                int red;
                Vec2 dir = new Vec2((double)e.getX() - this.pos.x, (double)e.getY() - this.pos.y);
                dir = dir.normalise();
                double x = this.pos.x + (double)this.shootOffset.x;
                double y = this.pos.y + (double)this.shootOffset.y;
                this.locationAtShot.x = (int)x;
                this.locationAtShot.y = (int)y;
                do {
                    y += dir.y;
                    if ((x += dir.x) > (double)this.terrainLevel.getBackground().getWidth() || x < 0.0 || y > (double)this.terrainLevel.getBackground().getHeight() || y < 0.0) {
                        return;
                    }
                    int c = this.terrainLevel.getBackground().getRGB((int)x, (int)y);
                    red = (c & 0xFF0000) >> 16;
                    green = (c & 0xFF00) >> 8;
                    blue = c & 0xFF;
                } while (red == 0 && green == 0 && blue == 0);
                this.placeLastShot.x = (int)x;
                this.placeLastShot.y = (int)y;
                this.lastShot = CrustyEngine.currentTimeMillis();
                this.terrainLevel.createLand((int)x, (int)y, 20, this.worm);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastMousePos.x = e.getX();
        this.lastMousePos.y = e.getY();
        if (this.attachedToWorm && this.worm != null) {
            Vec2 dir = new Vec2((double)e.getX() - this.pos.x, (double)e.getY() - this.pos.y);
            dir = dir.normalise();
            Vec2 up = new Vec2(0.0, 1.0);
            double angle = Vec2.angleBetweenTwoVectors(dir, up) - 1.5707963267948966;
            if ((double)e.getX() < this.pos.x) {
                this.drawFlippedVert = false;
                this.rotatePoint.x = 10.0;
                this.offset.y = 4;
            } else {
                this.drawFlippedVert = true;
                angle = -angle + Math.PI;
                this.rotatePoint.x = 13.0;
                this.offset.y = 4;
            }
            this.rotation = angle;
        }
    }
}

