/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.entities;

import java.awt.Color;
import java.awt.Graphics2D;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.levels.TerrainLevel;

public class Flag
extends Entity {
    Worm worm;
    int distanceToWormToTriggerEnd = 20;
    TerrainLevel screen;
    boolean triggered = false;
    long lastTriggered = 0L;
    long timeToSwitch = 1500L;
    double rad = 12.0;

    public Flag(Sprite[] sprites, int xoffset, int yoffset, Worm worm, TerrainLevel screen) {
        super(sprites, xoffset, yoffset);
        this.worm = worm;
        this.screen = screen;
        this.depth = 6;
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.triggered) {
            g.setColor(Color.WHITE);
            g.fillOval((int)(this.pos.x - this.rad + 10.0), (int)(this.pos.y - this.rad + 7.0), (int)this.rad * 2, (int)this.rad * 2);
        }
        super.draw(g);
    }

    @Override
    public void logic(long dt) {
        if (this.worm != null && this.worm.pos.sub(this.pos).length() < (double)this.distanceToWormToTriggerEnd && !this.triggered) {
            SoundManager.playSound("sounds/flag.wav");
            this.triggered = true;
            this.lastTriggered = CrustyEngine.currentTimeMillis();
        }
        if (this.triggered) {
            this.rad = (Math.sin((float)CrustyEngine.currentTimeMillis() / 100.0f) + 1.0) * 6.0;
            if (CrustyEngine.currentTimeMillis() - this.lastTriggered > this.timeToSwitch) {
                System.out.println("Trigger screen move.");
                this.screen.setCurrentScreen(this.screen.getNextScreen());
            }
        }
    }
}

