/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.perlin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Random;

public class PerlinNoise {
    static Random r = new Random();

    private static ColorModel generateColorModel() {
        byte[] r = new byte[16];
        byte[] g = new byte[16];
        byte[] b = new byte[16];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        r[1] = 0;
        g[1] = 0;
        b[1] = -64;
        r[2] = 0;
        g[2] = 0;
        b[2] = -1;
        r[3] = 0;
        g[3] = -64;
        b[3] = 0;
        r[4] = 0;
        g[4] = -1;
        b[4] = 0;
        r[5] = 0;
        g[5] = -64;
        b[5] = -64;
        r[6] = 0;
        g[6] = -1;
        b[6] = -1;
        r[7] = -64;
        g[7] = 0;
        b[7] = 0;
        r[8] = -1;
        g[8] = 0;
        b[8] = 0;
        r[9] = -64;
        g[9] = 0;
        b[9] = -64;
        r[10] = -1;
        g[10] = 0;
        b[10] = -1;
        r[11] = -64;
        g[11] = -64;
        b[11] = 0;
        r[12] = -1;
        g[12] = -1;
        b[12] = 0;
        r[13] = 80;
        g[13] = 80;
        b[13] = 80;
        r[14] = -64;
        g[14] = -64;
        b[14] = -64;
        r[15] = -1;
        g[15] = -1;
        b[15] = -1;
        return new IndexColorModel(4, 16, r, g, b);
    }

    public static BufferedImage doubleArrayToBufferedImage(double[] pixels, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int grey = (int)(pixels[width * y + x] * 255.0);
                if (grey > 0) {
                    grey = Math.max(Math.min(grey, 255), 0);
                    g.setColor(new Color(255, 255, 0, grey));
                    g.drawLine(x, y, x, y);
                } else {
                    grey = Math.min(Math.abs(grey), 255);
                    g.setColor(new Color(0, 0, 255, grey));
                    g.drawLine(x, y, x, y);
                }
                ++x;
            }
            ++y;
        }
        return bi;
    }

    public static BufferedImage doubleArrayToHeightImage(double[] pixels, int width, int height) {
        System.out.println("Starting Render");
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int grey = (int)(pixels[width * y + x] * 255.0);
                if (grey > 0) {
                    grey = Math.max(Math.min(grey, 255), 0);
                    g.setColor(new Color(0, 255, 0, grey));
                    g.drawLine(x, y, x, y - (int)((double)grey * 0.3));
                } else {
                    grey = Math.min(Math.abs(grey) + 150, 255);
                    g.setColor(new Color(100, 100, 255, grey));
                    g.drawLine(x, y, x, y);
                }
                ++x;
            }
            ++y;
        }
        System.out.println("Render Complete.");
        return bi;
    }

    public static BufferedImage doubleArrayToWormsImage(double[] pixels, int width, int height, Color colour) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int grey = (int)(pixels[width * y + x] * 255.0);
                if (grey > 0) {
                    g.setColor(colour);
                    g.drawLine(x, y, x, y);
                }
                ++x;
            }
            ++y;
        }
        return bi;
    }

    public static BufferedImage pixelArrayToBufferedImage(byte[] pixels, int width, int height) {
        DataBufferByte dbuf = new DataBufferByte(pixels, width * height, 0);
        int[] bitMasks = new int[]{15};
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(0, width, height, bitMasks);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbuf, null);
        ColorModel colorModel = PerlinNoise.generateColorModel();
        BufferedImage image = new BufferedImage(colorModel, raster, false, null);
        return image;
    }

    public static double interpolatedNoise1(double x, double y) {
        int integer_X = (int)x;
        double fractional_X = x - (double)integer_X;
        int integer_Y = (int)y;
        double fractional_Y = y - (double)integer_Y;
        double v1 = PerlinNoise.smoothNoise(integer_X, integer_Y);
        double v2 = PerlinNoise.smoothNoise(integer_X + 1, integer_Y);
        double v3 = PerlinNoise.smoothNoise(integer_X, integer_Y + 1);
        double v4 = PerlinNoise.smoothNoise(integer_X + 1, integer_Y + 1);
        double i1 = PerlinNoise.cosineInterpolate(v1, v2, fractional_X);
        double i2 = PerlinNoise.cosineInterpolate(v3, v4, fractional_X);
        return PerlinNoise.cosineInterpolate(i1, i2, fractional_Y);
    }

    public static double perlinNoise2D(double x, double y, double frequency, double persistance, double octaves, double amplitude) {
        double total = 0.0;
        int i = 0;
        while ((double)i < octaves) {
            total += PerlinNoise.interpolatedNoise1(x * frequency, y * frequency) * amplitude;
            frequency *= 2.0;
            amplitude *= persistance;
            ++i;
        }
        double cloudCoverage = 0.0;
        double cloudDensity = 1.0;
        total = (total + cloudCoverage) * cloudDensity;
        return total;
    }

    public static double int2DNoise(int x, int y) {
        int r1 = 15731;
        int r2 = 789221;
        int r3 = 1376312589;
        int n = x + y * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * r1 + r2) + r3 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    private static double cosineInterpolate(double a, double b, double x) {
        double ft = x * Math.PI;
        double f = (1.0 - Math.cos(ft)) * 0.5;
        return a * (1.0 - f) + b * f;
    }

    public static double smoothNoise(int x, int y) {
        double corners = (PerlinNoise.int2DNoise(x - 1, y - 1) + PerlinNoise.int2DNoise(x + 1, y - 1) + PerlinNoise.int2DNoise(x - 1, y + 1) + PerlinNoise.int2DNoise(x + 1, y + 1)) / 16.0;
        double sides = (PerlinNoise.int2DNoise(x - 1, y) + PerlinNoise.int2DNoise(x + 1, y) + PerlinNoise.int2DNoise(x, y - 1) + PerlinNoise.int2DNoise(x, y + 1)) / 8.0;
        double center = PerlinNoise.int2DNoise(x, y) / 4.0;
        return corners + sides + center;
    }
}

