/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.entity;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.crusty.math.Vec2;

public abstract class RootEntity
implements Comparable {
    public Vec2 pos = new Vec2(0.0, 0.0);
    public Vec2 vel = new Vec2(0.0, 0.0);
    public Vec2 acc = new Vec2(0.0, 0.0);
    public int depth = 0;
    protected float alpha = 1.0f;
    private Rectangle bounds = new Rectangle();

    public void setRect(int x, int y, int width, int height) {
        this.bounds.x = x;
        this.bounds.y = y;
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public Rectangle getRect() {
        return this.bounds;
    }

    public void logic(long dt) {
        this.vel.x += this.acc.x / 1000.0;
        this.vel.y += this.acc.y / 1000.0;
        this.pos.x += this.vel.x * (double)dt / 1000000.0;
        this.pos.y += this.vel.y * (double)dt / 1000000.0;
    }

    public abstract void draw(Graphics2D var1);

    public abstract void mousePressed(MouseEvent var1);

    public abstract void mouseMoved(MouseEvent var1);

    public int compareTo(Object o) {
        return this.depth - ((RootEntity)o).depth;
    }
}

