/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.GUI;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.crusty.engine.FontStore;
import org.crusty.engine.GUI.GraphicInterfaceObject;
import org.crusty.engine.GUI.MouseOverPane;
import org.crusty.engine.Screen;

public abstract class Button
extends GraphicInterfaceObject {
    Color normalColor = Color.YELLOW;
    Color mouseOverColor = Color.WHITE;
    String text = "";
    protected Screen screen;
    Font font = FontStore.smallFont;
    MouseOverPane mouseOverPane = null;
    private boolean displayingInfoPane = false;

    public Button(Screen s, int x, int y, int width, int height, MouseOverPane ip) {
        super(x, y, width, height);
        this.screen = s;
        this.setInfoPane(ip);
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        if (this.mouseOverPane != null) {
            if (this.mouseOver) {
                if (!this.displayingInfoPane) {
                    this.screen.addEntity(this.mouseOverPane);
                    this.displayingInfoPane = true;
                }
            } else if (this.displayingInfoPane) {
                this.displayingInfoPane = false;
                this.screen.getEntities().remove(this.mouseOverPane);
            }
        }
    }

    public void setText(String str) {
        this.text = str;
    }

    public void setInfoPane(MouseOverPane mouseOverPane) {
        this.mouseOverPane = mouseOverPane;
    }

    @Override
    public abstract void mousePressed(MouseEvent var1);

    @Override
    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(this.normalColor);
        if (this.mouseOver) {
            g.setColor(this.mouseOverColor);
        }
        g.drawRect(this.getRect().x, this.getRect().y, this.getRect().width, this.getRect().height);
        g.setFont(this.font);
        g.drawString(this.text, this.getRect().x + 10, this.getRect().y + 15);
    }
}

