package org.crusty.wurrums.levels;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Random;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;

import org.crusty.wurrums.entities.Fader;
import org.crusty.wurrums.entities.Flag;
import org.crusty.wurrums.entities.Floater;
import org.crusty.wurrums.entities.Gun;
import org.crusty.wurrums.entities.Worm;
import org.crusty.wurrums.enemies.Turret;

public class Level3 extends TerrainLevel {
	
	Worm worm;
	
	public Level3(CrustyEngine engine, TerrainLevel nextScreen) {
		super(engine, nextScreen);
		
		reset();
	}
	
	@Override
	public Worm getWorm() {
		return worm;
	}

	public void draw(Graphics2D g) {
		// Background
		g.setColor(new Color(150, 255, 150));
		g.fillRect(0, 0, this.background.getWidth(), this.background.getHeight());
		
		super.draw(g);
	}
	
	@Override
	public void reset() {
		// Remove all entities
		entities.clear();
		
		Random r = new Random();
		for (int i = 0; i < 5; i++) {
			// Random floaters to start with
			Sprite s = SpriteManager.getSprite("img/floaters/f" + Integer.toString(r.nextInt(3) + 1) + ".png");
			Floater f = new Floater(new Sprite[] { s }, 50, 50);
			f.pos.x = r.nextInt(100 + 800) - 100;
			f.pos.y = r.nextInt(200 + 600) - 200;
			addEntity(f);
//			System.out.println("Floater: " + f.pos);
		}
		
		SpriteManager.reloadSprite("img/levels/level3.png");
		Sprite s = SpriteManager.getSprite("img/levels/level3.png");
		
		this.background = s.images[0];
		
		if (s.images.length > 1) {
			this.solidbackground = s.images[1];
		}
		
		// Draw over solid background
		Graphics2D g = (Graphics2D) background.getGraphics();
		g.drawImage(solidbackground, 0, 0, null);
		
		Entity backgroundEntity = new Entity(new Sprite[] { s }, 0, 0);
		backgroundEntity.pos.x = 0;
		backgroundEntity.pos.y = 0;
		
		double 	wormx = 65, 
				wormy = 30;
		
		worm = new Worm(this, wormx, wormy, 
				new Sprite[] { 	SpriteManager.getSprite("WormWalkingLeft"),
								SpriteManager.getSprite("WormWalkingRight"),
								SpriteManager.getSprite("WormDeadLeft"),
								SpriteManager.getSprite("WormDeadRight"),
								SpriteManager.getSprite("WormFlyingLeft"),
								SpriteManager.getSprite("WormFlyingRight")
							},
								10, 18);
		
		Gun assaultRifle = new Gun(new Sprite[] { SpriteManager.getSprite("img/guns/assaultrifle.bmp") }, 13, 4, this);
		assaultRifle.setWorm(worm);
//		assaultRifle.canRightClick = true;
		worm.setGun(assaultRifle);
		
		Flag flag = new Flag(new Sprite[] { SpriteManager.getSprite("img/otherEntities/flag.bmp") }, 0, 0, worm, this);
		flag.pos.x = 710;
		flag.pos.y = 120;
		
		Sprite[] sprites = { SpriteManager.getSprite("img/otherEntities/turret.png") };
		Turret t = new Turret(sprites, 20, 20, worm, this);
		t.pos.x = 96;
		t.pos.y = 263;
		
		Turret t2 = new Turret(sprites, 20, 20, worm, this);
		t2.pos.x = 439;
		t2.pos.y = 266;
		
		addEntity(new Fader(new Color(150, 255, 150), 0.9f));
		addEntity(flag);
		addEntity(worm);
		addEntity(backgroundEntity);
		addEntity(assaultRifle);
		addEntity(t);
		addEntity(t2);
	}

}
