package org.crusty.wurrums.entities;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;

import org.crusty.wurrums.levels.TerrainLevel;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;

public class Gun extends Entity {

	/** Worm the gun is attached to */
	Worm worm = null;
//	BufferedImage background;
	TerrainLevel terrainLevel;
	
	int bulletTrailTime = 50;
	int timeBetweenShots = 150;
	long lastShot = CrustyEngine.currentTimeMillis();
	
	Vec2int placeLastShot = new Vec2int(0, 0);
	Vec2int locationAtShot = new Vec2int(0, 0);
	
	Vec2int shootOffset = new Vec2int(0, -3);
	Vec2int lastMousePos = new Vec2int(0, 0);
	public boolean canShoot = true;
	public boolean canRightClick = false;
	boolean attachedToWorm = false;
	
	public Gun(Sprite[] sprites, int xoffset, int yoffset, TerrainLevel terrainLevel) {
		super(sprites, xoffset, yoffset);
//		this.worm = worm;
		this.depth = 6;
//		this.background = background;
		this.terrainLevel = terrainLevel;
	}
	
	public void draw(Graphics2D g) {
		super.draw(g);
		
		// Bullet trail
		if (CrustyEngine.currentTimeMillis() - lastShot < bulletTrailTime) {
			g.setColor(Color.DARK_GRAY);
			g.drawLine(locationAtShot.x, locationAtShot.y, placeLastShot.x, placeLastShot.y);
		}
		
//		// Draw Mouse Pos
//		g.setFont(FontStore.smallFont);
//		g.setColor(Color.WHITE);
//		g.drawString("x: " + lastMousePos.x, 15, 40);
//		g.drawString("y: " + lastMousePos.y, 15, 60); // TODO REMOVE
	}
	
	public void setWormDontAttach(Worm w) {
		this.worm = w;
	}
	
	public void setWorm(Worm w) {
		this.worm = w;
		attachedToWorm = true;
		currentSprite = SpriteManager.getSprite("img/guns/assaultrifle.bmp");
		this.currentImage = currentSprite.images[0];
	}
	
	public void logic(long dt) {
		super.logic(dt);
		//currentSprite.logic(dt);
//		rotation += rotationalVel * dt / 1000000;
		
		if (!attachedToWorm) {
			this.offset.y = (int) ((Math.sin(CrustyEngine.currentTimeMillis() / 150f) + 1) * 4);
			if (worm.pos.sub(this.pos).length() < 10) {
				setWorm(worm);
				worm.setGun(this);
				SoundManager.playSound("sounds/pump.wav");
			}
		}
		
		if (attachedToWorm && worm != null) {
			pos.x = worm.pos.x;
			pos.y = worm.pos.y;
		}
//			
//			if (drawFlippedVert) {
//				offset.x = -2;
//				offset.y = 1;
////				pos.x -= 4;
////				pos.y -= 3;
//			} else {
//				offset.x = 10;
//				offset.y = 0;
//			}
//		}
		
	}

	@Override
	public void mousePressed(MouseEvent e) {
		if (canShoot && attachedToWorm && worm != null) {
			if (e.getButton() == MouseEvent.BUTTON1) {
				
				if (worm != null && terrainLevel != null) { 
					if (CrustyEngine.currentTimeMillis() - lastShot > timeBetweenShots) {
			//			System.out.println("Shoot");
						Vec2 dir = new Vec2(e.getX() - pos.x, e.getY() - pos.y);
						dir = dir.normalise();
						int red, green, blue;
						double x, y;
						x = pos.x + shootOffset.x;
						y = pos.y + shootOffset.y;
						locationAtShot.x = (int) x;
						locationAtShot.y = (int) y;
						do {
							x += dir.x;
							y += dir.y;
							if (x > terrainLevel.getBackground().getWidth() || x < 0 || y > terrainLevel.getBackground().getHeight() || y < 0)
								return;
							int c = terrainLevel.getBackground().getRGB((int) x, (int) y);
							red   = (c & 0x00ff0000) >> 16;
							green = (c & 0x0000ff00) >> 8;
							blue  = (c & 0x000000ff);
			//				System.out.println("x: " + x + " y: " + y);
						} while (red == 0 && green == 0 && blue == 0);
						// Hit spot at x, y
	//					System.out.println("Hit");
	//					Graphics2D g = (Graphics2D) background.getGraphics();
	//					Composite old = g.getComposite();
	//					
	//					// Make hole where gun shot
	//					g.setComposite(AlphaComposite.getInstance(AlphaComposite.DST_OUT, 1));
	//					g.setColor(Color.BLACK);
						int rad = 20;
	//					g.fillOval((int) x - rad, (int) y - rad, rad*2, rad*2);
	//					
	//					// Make line round hole
	//					g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_IN, 1));
	//					rad = 23;
	//					g.setColor(Color.WHITE);
	//					g.fillOval((int) x - rad, (int) y - rad, rad*2, rad*2);
	//					g.setComposite(old);
						
						terrainLevel.createHole(x, y, rad, worm);
						
						placeLastShot.x = (int) x;
						placeLastShot.y = (int) y;
						lastShot = CrustyEngine.currentTimeMillis();
						
	//					CrustyEngine.particleManager.addParticle(10, SpriteManager.getSprite("img/particles/explosion.bmp"), new Vec2(x, y), "crash");
						CrustyEngine.getParticleManager().createBurst(6, SpriteManager.getSprite("img/particles/dustcloud.bmp"), new Vec2(x, y));
					}
				}
			} else if (canRightClick && e.getButton() == MouseEvent.BUTTON3) {
				if (CrustyEngine.currentTimeMillis() - lastShot > timeBetweenShots) {
					
					Vec2 dir = new Vec2(e.getX() - pos.x, e.getY() - pos.y);
					dir = dir.normalise();
					int red, green, blue;
					double x, y;
					x = pos.x + shootOffset.x;
					y = pos.y + shootOffset.y;
					locationAtShot.x = (int) x;
					locationAtShot.y = (int) y;
					do {
						x += dir.x;
						y += dir.y;
						if (x > terrainLevel.getBackground().getWidth() || x < 0 || y > terrainLevel.getBackground().getHeight() || y < 0)
							return;
						int c = terrainLevel.getBackground().getRGB((int) x, (int) y);
						red   = (c & 0x00ff0000) >> 16;
						green = (c & 0x0000ff00) >> 8;
						blue  = (c & 0x000000ff);
		//				System.out.println("x: " + x + " y: " + y);
					} while (red == 0 && green == 0 && blue == 0);
					
					placeLastShot.x = (int) x;
					placeLastShot.y = (int) y;
					lastShot = CrustyEngine.currentTimeMillis();
					
					// Add land
					terrainLevel.createLand((int) x, (int) y, 20, worm);
				}
				
			}
		}
	}
	
	@Override
	public void mouseMoved(MouseEvent e) {
		lastMousePos.x = e.getX();
		lastMousePos.y = e.getY();
		
		if (attachedToWorm && worm != null) {
			Vec2 dir = new Vec2(e.getX() - pos.x, e.getY() - pos.y);
			dir = dir.normalise();
			Vec2 up = new Vec2(0, 1);
			double angle = Vec2.angleBetweenTwoVectors(dir, up) - Math.PI/2;
			if (e.getX() < pos.x) {
				drawFlippedVert = false;
				this.rotatePoint.x = 10;
//				this.offset.x = 13;
				this.offset.y = 4;
			} else {
				drawFlippedVert = true;
				angle = -angle + Math.PI;
				this.rotatePoint.x = 13;
				this.offset.y = 4;
			}
			rotation = angle;
		}
	}
}
