package org.crusty.wurrums.enemies;

import java.awt.Color;
import java.awt.Graphics2D;

import org.crusty.wurrums.levels.TerrainLevel;

import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;

import org.crusty.wurrums.entities.Worm;

public class Turret extends Entity {

	Worm worm;
	boolean targetting = false;
	TerrainLevel terrainLevel;
	long startTargettingTime = 0;
	int timeToKill = 700;
	boolean canKill = false;
	float firingStage = 0;
	
	public Turret(Sprite[] sprites, int xoffset, int yoffset, Worm worm, TerrainLevel terrainLevel) {
		super(sprites, xoffset, yoffset);
		this.worm = worm;
		this.terrainLevel = terrainLevel;
		depth = -20;
	}
	
	public void logic(long dt) {
		if (!worm.isDead()) {
			if (terrainLevel.isFree((int) pos.x, (int) pos.y, (int) worm.pos.x, (int) worm.pos.y)) {
				if (!targetting) {
					targetting = true;
					startTargettingTime = CrustyEngine.currentTimeMillis();
					SoundManager.playSound("sounds/turret.wav");
				}
			} else {
				targetting = false;
	//			System.out.println("Can't see: ");
			}
			
			if (targetting) {
				firingStage = (float) (CrustyEngine.currentTimeMillis() - startTargettingTime)/timeToKill;
				if (CrustyEngine.currentTimeMillis() - startTargettingTime > timeToKill) {
					worm.kill();
				}
			}
		} else {
			targetting = false;
		}
	}
	
	public void draw(Graphics2D g) {
		super.draw(g);
		
		if (targetting) {
			g.setColor(Color.RED);
			g.drawLine((int) pos.x, (int) pos.y, (int) worm.pos.x, (int) worm.pos.y);
			g.setColor(Color.RED);
			float rad = 30 - (firingStage * 30);
			g.drawOval((int) (pos.x - rad), (int) (pos.y - rad), (int) rad*2, (int) rad*2);
		}
		
	}

}
