/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.game;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.Screen;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.wurrums.levels.About;
import org.crusty.wurrums.levels.EditLevel;
import org.crusty.wurrums.levels.Intro;
import org.crusty.wurrums.levels.Level1;
import org.crusty.wurrums.levels.Level2;
import org.crusty.wurrums.levels.Level3;
import org.crusty.wurrums.levels.Level4;
import org.crusty.wurrums.levels.Level5;
import org.crusty.wurrums.levels.Level6;
import org.crusty.wurrums.levels.Level7;
import org.crusty.wurrums.levels.Level8;
import org.crusty.wurrums.levels.Menu;
import org.crusty.wurrums.levels.TerrainLevel;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class Game
extends CrustyEngine {
    private static final long serialVersionUID = -9001944339068409533L;
    public Screen screen1;
    public static Screen menu;
    public TerrainLevel level1;
    public TerrainLevel level2;
    public TerrainLevel level3;
    public TerrainLevel level4;
    public TerrainLevel level5;
    public TerrainLevel level6;
    public TerrainLevel level7;
    public TerrainLevel level8;
    public TerrainLevel intro;
    public TerrainLevel about;
    long songStart;
    Color[] colors = new Color[]{Color.WHITE, Color.YELLOW, Color.BLUE, Color.GREEN, Color.CYAN, Color.MAGENTA, Color.ORANGE, Color.RED, Color.BLACK};
    Random r = new Random();

    public Game(int width, int height, String title) {
        super(width, height, title);
        this.screen1 = new EditLevel(this);
        this.about = new About(this, null);
        this.level8 = new Level8(this, this.about);
        this.level7 = new Level7(this, this.level8);
        this.level6 = new Level6(this, this.level7);
        this.level5 = new Level5(this, this.level6);
        this.level4 = new Level4(this, this.level5);
        this.level3 = new Level3(this, this.level4);
        this.level2 = new Level2(this, this.level3);
        this.level1 = new Level1(this, this.level2);
        this.intro = new Intro(this, this.level1);
        this.currentScreen = menu = new Menu((CrustyEngine)this, new Screen[]{this.intro, this.about});
        AudioStream song = null;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("sounds/song.mid");
            InputStream in = url.openStream();
            song = new AudioStream(in);
            AudioPlayer.player.start((InputStream)song);
            this.songStart = CrustyEngine.currentTimeMillis();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Screen getMenu() {
        return menu;
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        if (CrustyEngine.currentTimeMillis() - this.songStart > 301000L) {
            this.songStart = CrustyEngine.currentTimeMillis();
            System.out.println("Replaying song.");
            AudioStream song = null;
            try {
                URL url = Thread.currentThread().getContextClassLoader().getResource("sounds/song.mid");
                InputStream in = url.openStream();
                song = new AudioStream(in);
                AudioPlayer.player.start((InputStream)song);
                this.songStart = CrustyEngine.currentTimeMillis();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Game g = new Game(800, 600, "Wurrums - Elliot Walmsley");
        g.gameLoop();
    }

    @Override
    public void loadImages() {
        String[] floaterSprites;
        String[] otherSprites;
        String[] backgroundSprites;
        String[] particleSprites;
        String[] gunSprites;
        String[] wormWalking = new String[]{"img/walking/w1.png", "img/walking/w2.png", "img/walking/w3.png", "img/walking/w4.png", "img/walking/w5.png", "img/walking/w6.png", "img/walking/w7.png"};
        SpriteManager.addSprite("WormWalkingLeft", wormWalking);
        SpriteManager.addFlipSprite("WormWalkingRight", wormWalking);
        String[] deadSprites = new String[]{"img/dead/d1.png"};
        SpriteManager.addSprite("WormDeadLeft", deadSprites);
        SpriteManager.addFlipSprite("WormDeadRight", deadSprites);
        String[] flyingSprites = new String[]{"img/flying/w1.png", "img/flying/w2.png"};
        SpriteManager.addSprite("WormFlyingLeft", flyingSprites);
        SpriteManager.addFlipSprite("WormFlyingRight", flyingSprites);
        String[] stringArray = gunSprites = new String[]{"img/guns/assaultrifle.bmp", "img/guns/assaultriflenoarm.bmp"};
        int n = gunSprites.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            SpriteManager.addSprite(s);
            ++n2;
        }
        String[] stringArray2 = particleSprites = new String[]{"img/particles/dustcloud.bmp", "img/particles/blood.bmp", "img/particles/bloodsmall.bmp"};
        int n3 = particleSprites.length;
        n = 0;
        while (n < n3) {
            String s = stringArray2[n];
            SpriteManager.addSprite(s);
            ++n;
        }
        String[] stringArray3 = backgroundSprites = new String[]{"img/backgrounds/back1.bmp", "img/backgrounds/back2.bmp", "img/backgrounds/back3.png", "img/backgrounds/back4.bmp", "img/backgrounds/newterrain.bmp"};
        int n4 = backgroundSprites.length;
        n3 = 0;
        while (n3 < n4) {
            String s = stringArray3[n3];
            SpriteManager.addSprite(s);
            ++n3;
        }
        String[] intro = new String[]{"img/levels/intro.png"};
        SpriteManager.addSprite("img/levels/intro.png", intro);
        String[] level1 = new String[]{"img/levels/level1.png"};
        SpriteManager.addSprite("img/levels/level1.png", level1);
        String[] level2 = new String[]{"img/levels/level2.png", "img/levels/level2solid.png"};
        SpriteManager.addSprite("img/levels/level2.png", level2);
        String[] level3 = new String[]{"img/levels/level3.png", "img/levels/level3solid.png"};
        SpriteManager.addSprite("img/levels/level3.png", level3);
        String[] level4 = new String[]{"img/levels/level4.png"};
        SpriteManager.addSprite("img/levels/level4.png", level4);
        String[] level5 = new String[]{"img/levels/level5.png"};
        SpriteManager.addSprite("img/levels/level5.png", level5);
        String[] level6 = new String[]{"img/levels/level6.png", "img/levels/level6solid.png"};
        SpriteManager.addSprite("img/levels/level6.png", level6);
        String[] level7 = new String[]{"img/levels/level7.png", "img/levels/level7solid.png"};
        SpriteManager.addSprite("img/levels/level7.png", level7);
        String[] level8 = new String[]{"img/levels/level8.png", "img/levels/level8solid.png"};
        SpriteManager.addSprite("img/levels/level8.png", level8);
        String[] stringArray4 = otherSprites = new String[]{"img/otherEntities/flag.bmp", "img/otherEntities/turret.png", "img/otherEntities/bloodsplat.png"};
        int n5 = otherSprites.length;
        int n6 = 0;
        while (n6 < n5) {
            String s = stringArray4[n6];
            SpriteManager.addSprite(s);
            ++n6;
        }
        String[] stringArray5 = floaterSprites = new String[]{"img/floaters/f1.png", "img/floaters/f2.png", "img/floaters/f3.png"};
        int n7 = floaterSprites.length;
        n5 = 0;
        while (n5 < n7) {
            String s = stringArray5[n5];
            SpriteManager.addSprite(s);
            ++n5;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.currentScreen.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.currentScreen != null) {
            this.currentScreen.mouseMoved(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

