/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.entities;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.Entity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.math.Vec2;
import org.crusty.util.DoubleUtil;
import org.crusty.wurrums.entities.Gun;
import org.crusty.wurrums.game.Game;
import org.crusty.wurrums.levels.TerrainLevel;

public class Worm
extends Entity {
    private boolean movementDebug = false;
    TerrainLevel terrainLevel;
    boolean onGround = false;
    boolean canControl = true;
    double maxVel = 5000.0;
    double maxHorizontalAirSpeed = 0.09;
    double maxGroundSpeed = 0.08;
    double gravity = 5.0;
    int vertMaxStep = 5;
    double initGroundVel = 0.3;
    int jumpAcc = -250;
    double friction = 0.96;
    boolean direction = true;
    long lastControl = 0L;
    Gun gun = null;
    int downTimeIfHitRoof = 300;
    boolean dead = false;
    Vec2 prevPos = new Vec2(0.0, 0.0);
    private long lastDied = 0L;
    private int deathTimeout = 2000;

    public Worm(TerrainLevel terrainLevel, double x, double y, Sprite[] sprites, int xoffset, int yoffset) {
        super(sprites, xoffset, yoffset);
        this.pos.x = x;
        this.pos.y = y;
        this.prevPos.x = x;
        this.prevPos.y = y;
        this.depth = 5;
        this.terrainLevel = terrainLevel;
        this.timeBetweenFrames = 50;
        this.animating = true;
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.movementDebug) {
            g.setColor(Color.BLACK);
            g.fillRect(5, 5, 200, 120);
            g.setColor(Color.WHITE);
            g.drawRect(5, 5, 200, 120);
            g.drawString("pos: " + DoubleUtil.roundTwoDec(this.pos.x) + ", " + DoubleUtil.roundTwoDec(this.pos.y), 10, 40);
            g.drawString("vel: " + DoubleUtil.roundTwoDec(this.vel.x) + ", " + DoubleUtil.roundTwoDec(this.vel.y), 10, 60);
            g.drawString("acc: " + DoubleUtil.roundTwoDec(this.acc.x) + ", " + DoubleUtil.roundTwoDec(this.acc.y), 10, 80);
            g.drawString("onGround: " + this.onGround, 10, 100);
            g.drawString("prevPos: " + DoubleUtil.roundTwoDec(this.prevPos.x) + ", " + DoubleUtil.roundTwoDec(this.prevPos.y), 10, 120);
        }
        super.draw(g);
    }

    public void setGun(Gun g) {
        this.gun = g;
    }

    public int groundPoint(int x, int low, int high) {
        int y = (low + high) / 2;
        if (this.terrainLevel.isFree(x, y)) {
            int i = (low + high) / 2;
            while (i < low) {
                if (i > this.terrainLevel.getHeight() - 1) {
                    return this.terrainLevel.getHeight() - 1;
                }
                if (!this.terrainLevel.isFree(x, i)) {
                    return i - 1;
                }
                ++i;
            }
            return -1;
        }
        int i = (low + high) / 2;
        while (i > high) {
            if (i < 0) break;
            if (this.terrainLevel.isFree(x, i)) {
                return i;
            }
            --i;
        }
        return -2;
    }

    @Override
    public void logic(long dt) {
        if (this.dead) {
            if (CrustyEngine.currentTimeMillis() - this.lastDied > (long)this.deathTimeout) {
                this.terrainLevel.reset();
            } else {
                Random r = new Random();
                if (r.nextInt(8) == 0) {
                    CrustyEngine.getParticleManager().createBloodBurst(1, SpriteManager.getSprite("img/particles/bloodsmall.bmp"), this.pos);
                }
            }
        }
        if (this.terrainLevel == null) {
            return;
        }
        if (this.animating && CrustyEngine.currentTimeMillis() - this.lastTime > (long)this.timeBetweenFrames) {
            this.lastTime = CrustyEngine.currentTimeMillis();
            ++this.curImage;
            if (this.curImage >= this.currentSprite.images.length) {
                this.curImage = 0;
            }
            this.currentImage = this.currentSprite.images[this.curImage];
        }
        this.rotation += this.rotationalVel * (double)dt / 1000000.0;
        this.acc.y = 0.0;
        this.acc.x = 0.0;
        if (!this.onGround) {
            this.acc.y = this.gravity;
        } else if (this.canControl && (Game.keys[32] || Game.keys[38] || Game.keys[87])) {
            if (this.movementDebug) {
                System.out.println("Jump");
            }
            SoundManager.playSound("sounds/jump.wav");
            this.acc.y = this.jumpAcc;
            this.onGround = false;
            this.currentSprite = !this.direction ? this.sprites[4] : this.sprites[5];
        }
        if (!this.dead && !this.canControl && CrustyEngine.currentTimeMillis() - this.lastControl > (long)this.downTimeIfHitRoof) {
            this.canControl = true;
        }
        boolean buttonPressed = false;
        if (this.canControl) {
            if (Game.keys[37] || Game.keys[65]) {
                this.acc.x = -3.0;
                this.direction = false;
                this.currentSprite = !this.onGround ? this.sprites[4] : this.sprites[0];
                this.setAnimating(true);
                buttonPressed = true;
            }
            if (Game.keys[39] || Game.keys[68]) {
                this.acc.x = 3.0;
                this.direction = true;
                this.currentSprite = !this.onGround ? this.sprites[5] : this.sprites[1];
                this.setAnimating(true);
                buttonPressed = true;
            }
        }
        if (!buttonPressed) {
            this.setAnimating(false);
            this.setCurImage(0);
        }
        this.vel.x += this.acc.x / 1000.0;
        this.vel.y += this.acc.y / 1000.0;
        if (this.onGround) {
            if (this.vel.length() > this.maxGroundSpeed) {
                Vec2 v = this.vel.normalise();
                this.vel.x = v.x * this.maxGroundSpeed;
                this.vel.y = v.y * this.maxGroundSpeed;
            }
        } else {
            if (this.vel.x > this.maxHorizontalAirSpeed) {
                this.vel.x = this.maxHorizontalAirSpeed;
            }
            if (this.vel.x < -this.maxHorizontalAirSpeed) {
                this.vel.x = -this.maxHorizontalAirSpeed;
            }
        }
        Vec2 newPos = new Vec2(this.pos.x + this.vel.x * (double)dt / 1000000.0, this.pos.y + this.vel.y * (double)dt / 1000000.0);
        if (newPos.x > (double)(this.terrainLevel.getWidth() - 1)) {
            newPos.x = this.terrainLevel.getWidth() - 1;
        }
        if (newPos.x < 0.0) {
            newPos.x = 0.0;
        }
        if (newPos.y > (double)(this.terrainLevel.getHeight() - 1)) {
            newPos.y = this.terrainLevel.getHeight() - 1;
            this.kill();
        }
        if (newPos.y < 0.0) {
            newPos.y = 0.0;
        }
        if (this.onGround) {
            int val;
            if (this.movementDebug) {
                System.out.println("--- OnGround");
            }
            if ((val = this.groundPoint((int)newPos.x, (int)newPos.y + this.vertMaxStep, (int)newPos.y - this.vertMaxStep)) == -2) {
                this.vel.x = 0.0;
                this.vel.y = 0.0;
                if (this.movementDebug) {
                    System.out.println("onGround - Can't go Uphill.");
                }
            } else if (val == -1) {
                this.onGround = false;
                this.pos.x = newPos.x;
                this.pos.y = newPos.y;
                if (this.movementDebug) {
                    System.out.println("onGround - Falling.");
                }
            } else {
                this.pos.x = newPos.x;
                this.pos.y = newPos.y = (double)val;
                if (this.movementDebug) {
                    System.out.println("onGround - Walking.");
                }
            }
            this.vel.x *= this.friction;
            this.vel.y *= this.friction;
        } else {
            if (this.movementDebug) {
                System.out.println("--- NOT OnGround");
            }
            if (this.terrainLevel.isFree((int)newPos.x, (int)newPos.y)) {
                this.pos.x = newPos.x;
                this.pos.y = newPos.y;
            } else {
                if (!this.dead) {
                    this.currentSprite = !this.direction ? this.sprites[0] : this.sprites[1];
                }
                int val = this.groundPoint((int)newPos.x, (int)newPos.y + this.vertMaxStep, (int)newPos.y - this.vertMaxStep);
                if (this.vel.y > 0.0) {
                    if (val == -2) {
                        this.vel.x = -this.vel.x;
                        this.vel.x /= 2.0;
                        this.vel.y /= 2.0;
                        SoundManager.playSound("sounds/hitground.wav");
                        if (this.movementDebug) {
                            System.out.println("Collided too far into ground");
                        }
                    } else if (val == -1) {
                        if (this.movementDebug) {
                            System.out.println("Wat Down");
                        }
                    } else if (this.vel.length() < this.initGroundVel) {
                        newPos.y = val;
                        this.pos.x = newPos.x;
                        this.pos.y = newPos.y;
                        this.onGround = true;
                        this.vel.x = 0.0;
                        this.vel.y = 0.0;
                        if (this.movementDebug) {
                            System.out.println("Going to ground");
                        }
                    } else {
                        this.vel.y = -this.vel.y * 0.5;
                        this.vel.x *= 0.5;
                        SoundManager.playSound("sounds/hitground.wav");
                        if (this.movementDebug) {
                            System.out.println("Bounce");
                        }
                    }
                } else {
                    this.vel.y = -this.vel.y * 0.5;
                    SoundManager.playSound("sounds/hitground.wav");
                    this.lastControl = CrustyEngine.currentTimeMillis();
                    this.canControl = false;
                    if (this.movementDebug) {
                        System.out.println("Bounce on Roof.");
                    }
                }
            }
        }
        if (this.terrainLevel.isFree((int)this.pos.x, (int)this.pos.y)) {
            this.prevPos.x = this.pos.x;
            this.prevPos.y = this.pos.y;
        }
    }

    public boolean isDead() {
        return this.dead;
    }

    public void kill() {
        if (!this.dead) {
            this.lastDied = CrustyEngine.currentTimeMillis();
            this.dead = true;
            this.terrainLevel.createHole(this.pos.x, this.pos.y, 40, this);
            this.canControl = false;
            this.gun.canShoot = false;
            this.currentSprite = this.direction ? this.sprites[3] : this.sprites[2];
            this.terrainLevel.drawBloodSplat(this.pos.x, this.pos.y);
            SoundManager.playSound("sounds/die.wav");
            CrustyEngine.getParticleManager().createBloodBurst(40, SpriteManager.getSprite("img/particles/blood.bmp"), this.pos);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

