/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.math;

import org.crusty.math.Vec2int;

public class Vec2 {
    public double x;
    public double y;

    public Vec2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void set(double f, double g) {
        this.x = f;
        this.y = g;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vec2 normalise() {
        double len = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        double xx = this.x;
        double yy = this.y;
        return new Vec2(xx *= len, yy *= len);
    }

    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    public Vec2 sub(Vec2int v) {
        return new Vec2(this.x - (double)v.x, this.y - (double)v.y);
    }

    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public Vec2 clone() {
        return new Vec2(this.x, this.y);
    }

    public boolean equalsTo(Vec2 v, double range) {
        return Math.abs(this.x - v.x) < range && Math.abs(this.y - v.y) < range;
    }

    public static double dotProd(Vec2 v1, Vec2 v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public static double angleBetweenTwoVectors(Vec2 v1, Vec2 v2) {
        return Math.acos(Vec2.dotProd(v1, v2));
    }

    public Vec2 perp() {
        return new Vec2(-this.y, this.x);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

