/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.sprite;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.crusty.engine.ImageManager;
import org.crusty.engine.sprite.Sprite;

public class SpriteManager {
    static HashMap<String, Sprite> sprites = new HashMap();
    String spritesFile = "sprites.crusty";

    public void loadSprites() {
        try {
            FileInputStream fis = new FileInputStream(new File(this.spritesFile));
            ObjectInputStream ois = new ObjectInputStream(fis);
            ois.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addFlipSprite(String str, String[] strImages) {
        BufferedImage[] images = new BufferedImage[strImages.length];
        int i = 0;
        while (i < strImages.length) {
            images[i] = ImageManager.flipImage(SpriteManager.loadImage(strImages[i]));
            ++i;
        }
        Sprite s = new Sprite(images, strImages);
        sprites.put(str, s);
    }

    public static void addSprite(String str, String[] strImages) {
        BufferedImage[] images = new BufferedImage[strImages.length];
        int i = 0;
        while (i < strImages.length) {
            images[i] = SpriteManager.loadImage(strImages[i]);
            ++i;
        }
        Sprite s = new Sprite(images, strImages);
        System.out.println("Sprite added: " + str + " (" + images.length + ")");
        sprites.put(str, s);
    }

    public static void addSprite(String str) {
        Sprite s = new Sprite(new BufferedImage[]{SpriteManager.loadImage(str)}, new String[]{str});
        sprites.put(str, s);
    }

    public static void reloadSprite(String str) {
        Sprite s = sprites.get(str);
        int i = 0;
        while (i < s.images.length) {
            s.images[i] = SpriteManager.loadImage(s.str[i]);
            ++i;
        }
    }

    public static void addSprite(BufferedImage img, String str) {
        Sprite s = new Sprite(new BufferedImage[]{img}, new String[]{str});
        sprites.put(str, s);
    }

    public static BufferedImage dupe(BufferedImage image) {
        BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        return bi;
    }

    private static BufferedImage loadImage(String str) {
        System.out.println("Loading: " + str);
        URL url = Thread.currentThread().getContextClassLoader().getResource(str);
        BufferedImage img = null;
        try {
            img = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        bi = ImageManager.makeColorTransparent(bi, Color.RED);
        return bi;
    }

    public static Sprite getSprite(String str) {
        Sprite s = sprites.get(str);
        if (s != null) {
            return s;
        }
        System.out.println("Can't find: " + str);
        System.exit(-1);
        return null;
    }
}

