/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.engine.GUI;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.FontStore;
import org.crusty.engine.entity.RootEntity;
import org.crusty.math.Vec2int;

public abstract class Menu
extends RootEntity {
    protected String[] options;
    protected Vec2int pos;
    protected int spacing = 50;
    protected int menuPos;
    private Color selectColor;
    private Color nonSelectColor;
    private long lastMoved;
    private int menuDelay = 150;
    private Font font;

    public Menu(Vec2int pos, String[] options) {
        this.options = options;
        this.pos = pos;
        this.menuPos = 0;
        this.selectColor = Color.WHITE;
        this.nonSelectColor = Color.GREEN;
        this.lastMoved = System.currentTimeMillis();
        this.font = FontStore.mainFont;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public void setPosition(int x, int y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    @Override
    public void draw(Graphics2D g) {
        g.setFont(this.font);
        int i = 0;
        while (i < this.options.length) {
            if (this.menuPos == i) {
                g.setColor(this.selectColor);
            } else {
                g.setColor(this.nonSelectColor);
            }
            g.drawString(this.options[i], this.pos.x, this.pos.y + i * this.spacing);
            ++i;
        }
    }

    @Override
    public void logic(long dt) {
        if (System.currentTimeMillis() - this.lastMoved > (long)this.menuDelay) {
            if (CrustyEngine.keys[87] || CrustyEngine.keys[38]) {
                this.lastMoved = System.currentTimeMillis();
                --this.menuPos;
                if (this.menuPos < 0) {
                    this.menuPos = this.options.length - 1;
                }
                this.movedMenuItem();
            }
            if (CrustyEngine.keys[83] || CrustyEngine.keys[40]) {
                this.lastMoved = System.currentTimeMillis();
                ++this.menuPos;
                if (this.menuPos > this.options.length - 1) {
                    this.menuPos = 0;
                }
                this.movedMenuItem();
            }
            if (CrustyEngine.keys[10] || CrustyEngine.keys[32]) {
                this.lastMoved = System.currentTimeMillis();
                this.activateMenuItem(this.menuPos);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int option = 0;
        while (option < this.options.length) {
            if (e.getY() > this.pos.y + this.spacing * option - this.spacing + 10 && e.getY() < this.pos.y + this.spacing * option + 10) {
                this.menuPos = option;
            }
            ++option;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int option = 0;
        while (option < this.options.length) {
            if (e.getY() > this.pos.y + this.spacing * option - this.spacing + 10 && e.getY() < this.pos.y + this.spacing * option + 10) {
                this.activateMenuItem(this.menuPos);
            }
            ++option;
        }
    }

    public abstract void movedMenuItem();

    public abstract void activateMenuItem(int var1);
}

