/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.wurrums.levels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.crusty.engine.CrustyEngine;
import org.crusty.engine.Screen;
import org.crusty.engine.SoundManager;
import org.crusty.engine.entity.RootEntity;
import org.crusty.engine.sprite.Sprite;
import org.crusty.engine.sprite.SpriteManager;
import org.crusty.math.Vec2;
import org.crusty.wurrums.entities.Floater;
import org.crusty.wurrums.entities.Worm;

public abstract class TerrainLevel
extends Screen {
    BufferedImage background;
    BufferedImage solidbackground;
    Color colour = new Color(255, 255, 155, 255);
    TerrainLevel nextScreen;
    long lastSpawned = 0L;
    private long spawnFloaterTimer = 4000L;

    public TerrainLevel(CrustyEngine engine, TerrainLevel nextScreen) {
        super(engine);
        this.nextScreen = nextScreen;
    }

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
    }

    @Override
    public void setCurrentScreen(Screen s) {
        super.setCurrentScreen(s);
        if (s instanceof TerrainLevel) {
            ((TerrainLevel)s).reset();
        }
    }

    @Override
    public void logic(long dt) {
        super.logic(dt);
        if (CrustyEngine.currentTimeMillis() - this.lastSpawned > this.spawnFloaterTimer) {
            this.lastSpawned = CrustyEngine.currentTimeMillis();
            Random r = new Random();
            Sprite s = SpriteManager.getSprite("img/floaters/f" + Integer.toString(r.nextInt(3) + 1) + ".png");
            this.addEntity(new Floater(new Sprite[]{s}, 50, 50));
        }
        for (RootEntity f : this.getEntities()) {
            if (!(f instanceof Floater) || !((Floater)f).markedForDeletion) continue;
            this.entities.remove(f);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public abstract Worm getWorm();

    public abstract void reset();

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
    }

    public Screen getNextScreen() {
        return this.nextScreen;
    }

    public BufferedImage getBackground() {
        return this.background;
    }

    public void createHole(double x, double y, int rad, Worm worm) {
        Graphics2D g = (Graphics2D)this.background.getGraphics();
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(8, 1.0f));
        g.setColor(Color.BLACK);
        g.fillOval((int)x - rad, (int)y - rad, rad * 2, rad * 2);
        g.setComposite(AlphaComposite.getInstance(5, 1.0f));
        rad = 23;
        g.setColor(Color.WHITE);
        g.fillOval((int)x - rad, (int)y - rad, rad * 2, rad * 2);
        rad = 21;
        g.setColor(Color.BLACK);
        g.fillOval((int)x - rad, (int)y - rad, rad * 2, rad * 2);
        g.setComposite(old);
        g.drawImage((Image)this.solidbackground, 0, 0, null);
        Vec2 vec2 = new Vec2(x, y);
        if (vec2.sub(worm.pos).length() < (double)rad) {
            worm.kill();
        }
        SoundManager.playSound("sounds/explosion.wav");
    }

    public boolean isFree(int x, int y) {
        int c = this.background.getRGB(x, y);
        int alpha = (c & 0xFF000000) >> 24;
        return alpha == 0;
    }

    public boolean isFree(int x, int y, int x2, int y2) {
        Vec2 p1 = new Vec2(x, y);
        Vec2 p2 = new Vec2(x2, y2);
        Vec2 vec = p2.sub(p1);
        vec = vec.normalise();
        while (p1.sub(p2).length() > 2.0) {
            if (!this.isFree((int)p1.x, (int)p1.y)) {
                return false;
            }
            p1.x += vec.x;
            p1.y += vec.y;
        }
        return true;
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public void drawBloodSplat(double x, double y) {
        Graphics2D g = (Graphics2D)this.background.getGraphics();
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(10, 1.0f));
        Sprite bloodsplat = SpriteManager.getSprite("img/otherEntities/bloodsplat.png");
        BufferedImage currentImage = bloodsplat.images[0];
        double scale = 2.0;
        int x1 = 0;
        int y1 = 0;
        int x2 = bloodsplat.getWidth();
        int y2 = bloodsplat.getHeight();
        int scaleBorderx = (int)((double)bloodsplat.getWidth() * (scale - 1.0));
        int scaleBordery = (int)((double)bloodsplat.getHeight() * (scale - 1.0));
        g.drawImage(currentImage, (int)(x - 25.0) - scaleBorderx, (int)(y - 25.0) - scaleBordery, (int)(x - 25.0 + (double)bloodsplat.getWidth()) + scaleBorderx, (int)(y - 25.0 + (double)bloodsplat.getHeight()) + scaleBordery, x1, y1, x2, y2, null);
        g.setComposite(old);
    }

    public void createLand(int x, int y, int rad, Worm worm) {
        BufferedImage buildLayer = new BufferedImage(this.background.getWidth(), this.background.getHeight(), 2);
        Graphics2D g = (Graphics2D)buildLayer.getGraphics();
        g.setColor(this.colour);
        g.fillOval(x - (rad -= 2), y - rad, rad * 2, rad * 2);
        rad += 2;
        Sprite texture = SpriteManager.getSprite("img/backgrounds/newterrain.bmp");
        AlphaComposite ac = AlphaComposite.getInstance(5, 1.0f);
        Composite old = g.getComposite();
        g.setComposite(ac);
        int y1 = 0;
        while (y1 <= this.background.getHeight()) {
            int x1 = 0;
            while (x1 <= this.background.getWidth()) {
                g.drawImage((Image)texture.images[0], x1, y1, null);
                x1 += texture.getWidth();
            }
            y1 += texture.getHeight();
        }
        g.setComposite(old);
        Graphics2D g2 = (Graphics2D)this.background.getGraphics();
        old = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(4, 1.0f));
        g2.drawImage((Image)buildLayer, 0, 0, null);
        g2.setComposite(old);
        g2.drawImage((Image)this.solidbackground, 0, 0, null);
        SoundManager.playSound("sounds/createland.wav");
        Vec2 vec2 = new Vec2(x, y);
        if (vec2.sub(worm.pos).length() < (double)rad) {
            worm.kill();
        }
    }
}

