/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.math;

import org.crusty.math.Vec2;
import org.crusty.math.Vec2int;

public class Vec2double {
    public double x;
    public double y;

    public Vec2double(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void set(double f, double g) {
        this.x = f;
        this.y = g;
    }

    public Vec2double rotate(Vec2double point, double angle) {
        double xx = (this.x - point.x) * Math.cos(angle) - (point.y - this.y) * Math.sin(angle);
        double yy = (point.y - this.y) * Math.cos(angle) - (this.x - point.x) * Math.sin(angle);
        Vec2double v = new Vec2double(xx, yy);
        return v;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vec2double normalise() {
        double len = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        return new Vec2double(this.x * len, this.y * len);
    }

    public Vec2double sub(Vec2double vec2double) {
        return new Vec2double(this.x - vec2double.x, this.y - vec2double.y);
    }

    public Vec2double sub(Vec2int v) {
        return new Vec2double(this.x - (double)v.x, this.y - (double)v.y);
    }

    public Vec2double add(Vec2double v) {
        return new Vec2double(this.x + v.x, this.y + v.y);
    }

    public Vec2double clone() {
        return new Vec2double(this.x, this.y);
    }

    public boolean equalsTo(Vec2 v, double range) {
        return Math.abs(this.x - v.x) < range && Math.abs(this.y - v.y) < range;
    }

    public static double dotProd(Vec2 v1, Vec2 v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public Vec2double perp() {
        return new Vec2double(-this.y, this.x);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

