/*
 * Decompiled with CFR 0.152.
 */
package org.crusty.math;

import org.crusty.math.Vec2int;

public class Vec2 {
    float x;
    float y;

    public Vec2(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void set(float f, float g) {
        this.x = f;
        this.y = g;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vec2 normalise() {
        float len = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
        this.x *= len;
        this.y *= len;
        return this;
    }

    public Vec2 sub(Vec2 v) {
        return new Vec2(this.x - v.x, this.y - v.y);
    }

    public Vec2 sub(Vec2int v) {
        return new Vec2(this.x - (float)v.x, this.y - (float)v.y);
    }

    public Vec2 add(Vec2 v) {
        return new Vec2(this.x + v.x, this.y + v.y);
    }

    public Vec2 clone() {
        return new Vec2(this.x, this.y);
    }

    public boolean equalsTo(Vec2 v, float range) {
        return Math.abs(this.x - v.x) < range && Math.abs(this.y - v.y) < range;
    }

    public static float dotProd(Vec2 v1, Vec2 v2) {
        return v1.x * v2.x + v1.y * v2.y;
    }

    public Vec2 perp() {
        return new Vec2(-this.y, this.x);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

