/*
 * Decompiled with CFR 0.152.
 */
package ludumdare.game;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.PriorityQueue;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ludumdare.game.DepthComparator;
import ludumdare.game.Entity;
import ludumdare.game.ImageManager;
import ludumdare.game.MessageManager;
import ludumdare.game.ParticleManager;
import ludumdare.game.PieceOfRocket;
import ludumdare.game.Player;
import ludumdare.game.Rocket;
import ludumdare.game.Screen;
import ludumdare.game.ScreenManager;
import ludumdare.game.Sprite;
import ludumdare.game.SpriteManager;
import ludumdare.game.StarController;
import org.crusty.math.Vec2double;
import org.crusty.math.Vec2int;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class Game
extends Canvas {
    public static ParticleManager pm = new ParticleManager();
    static PriorityQueue<Entity> entities;
    public DepthComparator depthComparator = new DepthComparator();
    public static boolean[] keys;
    Font mainFont = new Font("Courier New", 1, 24);
    static Font smallFont;
    BufferStrategy strategy;
    private long lastTime;
    private long dt;
    private long accumulator;
    private long deltaTime = 10000000L;
    private GraphicsConfiguration gc;
    private long songStart;
    Vec2int screen = new Vec2int(0, 0);
    Rocket rocket;
    Entity ground;
    PieceOfRocket rocketBottom;
    PieceOfRocket rocketMiddle;
    PieceOfRocket rocketCapsule;
    PieceOfRocket rocketTip;
    private long genPurpAccum = 0L;
    static Player player;
    static boolean notifyUpdateScreen;

    static {
        smallFont = new Font("Courier New", 1, 12);
        notifyUpdateScreen = false;
    }

    public Game() {
        this.loadImages();
        this.init();
        this.gameLoop();
    }

    public void init() {
        player = new Player(SpriteManager.getSprite("capsule.png"));
        keys = new boolean[150];
        entities = new PriorityQueue<Entity>(10, this.depthComparator);
        PriorityQueue<Entity> rootEnts = new PriorityQueue<Entity>(10, this.depthComparator);
        this.rocket = new Rocket();
        this.rocket.depth = 1;
        rootEnts.add(this.rocket);
        this.ground = new Entity(SpriteManager.getSprite("ground.png"));
        rootEnts.add(this.ground);
        String[] rootMessages = new String[]{"Hold Space bar to take off!", "Good Luck Astroman!"};
        ScreenManager.setRoot(rootEnts, rootMessages);
        ScreenManager.currentScreen = ScreenManager.getRoot();
        ScreenManager.currentScreen.setupBackgroundStars();
        PriorityQueue<Entity> screen2Entities = new PriorityQueue<Entity>(10, this.depthComparator);
        this.rocketBottom = new PieceOfRocket("rocketBottom.png");
        this.rocketMiddle = new PieceOfRocket("rocketMiddle.png");
        this.rocketCapsule = new PieceOfRocket("rocketCapsule.png");
        this.rocketTip = new PieceOfRocket("rocketTip.png");
        screen2Entities.add(this.rocketBottom);
        this.rocketBottom.pos.x = 200.0;
        this.rocketBottom.pos.y = 180.0;
        this.rocketBottom.bottom = true;
        this.rocketBottom.rotatePoint.set(47.0, 140.0);
        screen2Entities.add(this.rocketMiddle);
        this.rocketMiddle.pos.x = 200.0;
        this.rocketMiddle.pos.y = 180.0;
        this.rocketMiddle.rotatePoint.set(43.0, 72.0);
        screen2Entities.add(this.rocketCapsule);
        this.rocketCapsule.pos.x = 200.0;
        this.rocketCapsule.pos.y = 180.0;
        this.rocketCapsule.rotatePoint.set(45.0, 35.0);
        screen2Entities.add(this.rocketTip);
        this.rocketTip.pos.x = 200.0;
        this.rocketTip.pos.y = 180.0;
        this.rocketTip.rotatePoint.set(45.0, 14.0);
        String[] screen2Messages = new String[]{"To infinity, and behond.", "Press F to jettison fuel.", "To go where none have gone.", "Press B to jettison body.", "May the force be with you.", "Press T to jettison tip.", "Live long, and prosper.", "Congrats! You're in SPACE!", "Mission: 'Wormhole Discovery'"};
        Screen screen2 = new Screen(screen2Entities, screen2Messages);
        screen2.stars = true;
        screen2.nextScreen = ScreenManager.getFirstScreen(new Vec2int(0, 0), new Vec2double(240.0, 237.0));
        ScreenManager.currentScreen.nextScreen = screen2;
        entities.clear();
        entities.addAll(ScreenManager.currentScreen.entitiesInScreen);
        JFrame container = new JFrame("The Adventures of ASTROMAN! - by Elliot Walmsley");
        JPanel panel = (JPanel)container.getContentPane();
        panel.setPreferredSize(new Dimension(500, 500));
        panel.setLayout(null);
        this.setBounds(0, 0, 500, 500);
        panel.add(this);
        this.setIgnoreRepaint(true);
        container.pack();
        container.setResizable(false);
        container.setVisible(true);
        container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.addKeyListener(new KeyInputHandler());
        this.requestFocus();
        this.createBufferStrategy(2);
        this.strategy = this.getBufferStrategy();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        this.gc = gd.getDefaultConfiguration();
    }

    public BufferedImage loadImage(String str) {
        BufferedImage image = null;
        URL url = this.getClass().getClassLoader().getResource(str);
        try {
            image = ImageManager.makeColorTransparent(ImageIO.read(url), Color.RED);
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void loadImages() {
        String[] images;
        String[] stringArray = images = new String[]{"rocket.png", "rocketBottom.png", "rocketCapsule.png", "rocketMiddle.png", "rocketTip.png", "ground.png", "fire.png", "star.png", "capsule.png", "planet1.png", "smoke.png", "jet.png", "bigstar.png", "blackhole.png", "bluestar.png", "planet2.png", "wormhole.png", "stationalpha.png"};
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            SpriteManager.addSprite(s, new Sprite(this.loadImage(s)));
            ++n2;
        }
    }

    public void gameLoop() {
        FileInputStream in;
        boolean running = true;
        boolean firstTime = true;
        AudioStream song = null;
        try {
            in = new FileInputStream("test.mid");
            song = new AudioStream((InputStream)in);
            AudioPlayer.player.start((InputStream)song);
            this.songStart = System.currentTimeMillis();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedImage bi = this.gc.createCompatibleImage(500, 500);
        Graphics2D g = null;
        Graphics graphics = null;
        while (running) {
            long now = System.nanoTime();
            this.dt = now - this.lastTime;
            float fps = 1000000000L / this.dt;
            this.lastTime = now;
            this.accumulator += this.dt;
            if (firstTime) {
                this.accumulator = 0L;
                firstTime = false;
            }
            while (this.accumulator >= this.deltaTime) {
                this.logic(this.deltaTime);
                this.accumulator -= this.deltaTime;
            }
            g = bi.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 500, 500);
            g.setColor(Color.WHITE);
            if (ScreenManager.currentScreen.stars) {
                StarController.update(this.dt);
                StarController.draw(g);
            }
            if (ScreenManager.currentScreen.backStars) {
                ScreenManager.currentScreen.draw(g);
            }
            Iterator<Entity> it = entities.iterator();
            while (it.hasNext()) {
                it.next().draw(g);
            }
            pm.draw(g);
            g.setFont(smallFont);
            g.setColor(Color.WHITE);
            g.drawString("FPS: " + fps, 15, 20);
            if (MessageManager.getNum() == 0) {
                g.setFont(this.mainFont);
                g.drawString("The", 200, 100);
                g.drawString("Adventures", 150, 130);
                g.drawString("of", 210, 160);
                g.drawString("ASTROMAN.", 170, 190);
                g.setFont(smallFont);
                g.drawString("a 48 hour game.", 50, 300);
                g.drawString("by Elliot Walmsley", 50, 320);
                g.drawString("Ludum Dare 19.", 50, 340);
            }
            g.setFont(this.mainFont);
            g.drawString("> " + MessageManager.getMessage(), 20, 50);
            if (System.currentTimeMillis() > this.songStart + 70000L) {
                AudioPlayer.player.stop((InputStream)song);
                try {
                    in = new FileInputStream("test.mid");
                    song = new AudioStream((InputStream)in);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                AudioPlayer.player.start((InputStream)song);
                AudioPlayer.player.start((InputStream)song);
                this.songStart = System.currentTimeMillis();
                System.out.println("SONG RESTART");
            }
            if (!this.strategy.contentsLost()) {
                graphics = this.strategy.getDrawGraphics();
            }
            graphics.drawImage(bi, 0, 0, null);
            if (!this.strategy.contentsLost()) {
                this.strategy.show();
            }
            Thread.yield();
            if (graphics != null) {
                graphics.dispose();
            }
            if (g == null) continue;
            g.dispose();
        }
    }

    public void logic(long dt) {
        pm.update(dt);
        Iterator<Entity> it = entities.iterator();
        while (it.hasNext()) {
            it.next().logic(dt);
        }
        switch (MessageManager.getNum()) {
            case 0: {
                if (!keys[32]) break;
                ScreenManager.notifyIncrement();
                try {
                    FileInputStream in = new FileInputStream("rocketLaunch.wav");
                    AudioStream as = new AudioStream((InputStream)in);
                    AudioPlayer.player.start((InputStream)as);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                if (!(this.rocket.pos.y < -400.0)) break;
                ScreenManager.notifyIncrement();
                break;
            }
            case 2: {
                if (this.genPurpAccum < 5000000000L) {
                    this.genPurpAccum += dt;
                    break;
                }
                ScreenManager.notifyIncrement();
                this.genPurpAccum = 0L;
                break;
            }
            case 3: {
                if (!keys[70]) break;
                ScreenManager.notifyIncrement();
                this.rocketBottom.activated = false;
                this.rocketBottom.acc.y = 0.4f;
                this.rocketBottom.acc.x = 0.1f;
                this.rocketBottom.rotationalVel = 0.001f;
                ParticleManager.addParticle(10, SpriteManager.getSprite("star.png"), this.rocketBottom.pos.add(this.rocketBottom.rotatePoint.clone()), "jettisonSparks");
                ParticleManager.addParticle(1, SpriteManager.getSprite("smoke.png"), this.rocketBottom.pos.add(this.rocketBottom.rotatePoint.clone()), "rocketSmoke");
                try {
                    FileInputStream in = new FileInputStream("detatch.wav");
                    AudioStream as = new AudioStream((InputStream)in);
                    AudioPlayer.player.start((InputStream)as);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                if (this.genPurpAccum < 5000000000L) {
                    this.genPurpAccum += dt;
                    break;
                }
                ScreenManager.notifyIncrement();
                this.genPurpAccum = 0L;
                break;
            }
            case 5: {
                if (!keys[66]) break;
                ScreenManager.notifyIncrement();
                this.rocketMiddle.activated = false;
                this.rocketMiddle.acc.y = 0.4f;
                this.rocketMiddle.acc.x = 0.1f;
                this.rocketMiddle.rotationalVel = 0.001f;
                ParticleManager.addParticle(10, SpriteManager.getSprite("star.png"), this.rocketMiddle.pos.add(this.rocketMiddle.rotatePoint.clone()), "jettisonSparks");
                ParticleManager.addParticle(1, SpriteManager.getSprite("smoke.png"), this.rocketBottom.pos.add(this.rocketMiddle.rotatePoint.clone()), "rocketSmoke");
                try {
                    FileInputStream in = new FileInputStream("detatch.wav");
                    AudioStream as = new AudioStream((InputStream)in);
                    AudioPlayer.player.start((InputStream)as);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 6: {
                if (this.genPurpAccum < 5000000000L) {
                    this.genPurpAccum += dt;
                    break;
                }
                ScreenManager.notifyIncrement();
                this.genPurpAccum = 0L;
                break;
            }
            case 7: {
                if (!keys[84]) break;
                ScreenManager.notifyIncrement();
                this.rocketTip.activated = false;
                this.rocketTip.acc.y = 0.4f;
                this.rocketTip.acc.x = 0.1f;
                this.rocketTip.rotationalVel = 0.005f;
                ParticleManager.addParticle(10, SpriteManager.getSprite("star.png"), this.rocketTip.pos.add(this.rocketTip.rotatePoint.clone()), "jettisonSparks");
                ParticleManager.addParticle(1, SpriteManager.getSprite("smoke.png"), this.rocketBottom.pos.add(this.rocketTip.rotatePoint.clone()), "rocketSmoke");
                try {
                    FileInputStream in = new FileInputStream("detatch.wav");
                    AudioStream as = new AudioStream((InputStream)in);
                    AudioPlayer.player.start((InputStream)as);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                if (this.genPurpAccum < 3000000000L) {
                    this.genPurpAccum += dt;
                    break;
                }
                ScreenManager.notifyIncrement();
                this.genPurpAccum = 0L;
                break;
            }
            case 9: {
                if (this.genPurpAccum < 2000000000L) {
                    this.genPurpAccum += dt;
                    break;
                }
                ScreenManager.notifyIncrement();
                this.genPurpAccum = 0L;
                break;
            }
            case 10: {
                if (this.genPurpAccum < 2000000000L) {
                    this.genPurpAccum += dt;
                    break;
                }
                ScreenManager.notifyIncrement();
                this.genPurpAccum = 0L;
            }
        }
        if (notifyUpdateScreen) {
            Game.updateScreen();
            notifyUpdateScreen = false;
        }
    }

    public static void notifyUpdate() {
        notifyUpdateScreen = true;
    }

    public static void main(String[] args) {
        Game g = new Game();
    }

    public static void updateScreen() {
        System.out.println("UPDATESCREEN");
        entities.clear();
        entities.addAll(ScreenManager.currentScreen.entitiesInScreen);
        System.out.println("after");
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() < 150) {
                Game.keys[e.getKeyCode()] = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() < 150) {
                Game.keys[e.getKeyCode()] = false;
            }
        }
    }
}

