/*
 * Decompiled with CFR 0.152.
 */
package ludumdare.game;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import ludumdare.game.Sprite;
import org.crusty.math.Vec2double;

public class Entity {
    Vec2double pos = new Vec2double(0.0, 0.0);
    Vec2double vel = new Vec2double(0.0, 0.0);
    Vec2double acc = new Vec2double(0.0, 0.0);
    Vec2double rotatePoint;
    Sprite sprite;
    public int depth = 0;
    double rotation = 0.0;
    public double rotationalVel = 0.0;

    public Entity(Sprite sprite) {
        this.sprite = sprite;
        this.rotatePoint = new Vec2double(sprite.image.getWidth() / 2, sprite.image.getHeight() / 2);
    }

    public void logic(double dt) {
        this.vel.x += this.acc.x / 1000.0;
        this.vel.y += this.acc.y / 1000.0;
        this.pos.x += this.vel.x * dt / 1000000.0;
        this.pos.y += this.vel.y * dt / 1000000.0;
        this.rotation += this.rotationalVel * dt / 1000000.0;
    }

    public void draw(Graphics2D g) {
        AffineTransform save = g.getTransform();
        g.rotate(this.rotation, this.pos.x + this.rotatePoint.x, this.pos.y + this.rotatePoint.y);
        g.drawImage((Image)this.sprite.image, (int)this.pos.x, (int)this.pos.y, null);
        g.rotate(-this.rotation, this.pos.x + this.rotatePoint.x, this.pos.y + this.rotatePoint.y);
        g.setTransform(save);
    }
}

