/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

public class Player
extends Entity {
    Game game;
    double previusY;
    double previusX;
    private Sprite[] framesRight = new Sprite[4];
    private Sprite[] framesLeft = new Sprite[4];
    private Sprite[] framesSpiderRight = new Sprite[4];
    private Sprite[] framesSpiderLeft = new Sprite[4];
    private Sprite[] framesSpiderAttackRight = new Sprite[4];
    private Sprite[] framesSpiderAttackLeft = new Sprite[4];
    private Sprite[] framesMindControl = new Sprite[3];
    public long lastFrameChange;
    private long frameDuration = 250L;
    private int frameNumber;
    public int hp = 30;
    private boolean lastDir = false;
    public boolean mindControlling = false;
    public boolean justMindControlled = false;
    public boolean initiatingMindControl = false;
    public boolean initiatingExplode = false;
    public boolean attacking = false;
    public Rectangle jumpSquare = new Rectangle();

    public Player(Game game, int x, int y) {
        super("sprites/player/p1.png", x, y, -1, 0, 50, 150, true);
        this.game = game;
        this.framesRight[0] = this.sprite;
        this.framesRight[1] = ResourceFactory.get().getSprite("sprites/player/p2.png");
        this.framesRight[2] = ResourceFactory.get().getSprite("sprites/player/p3.png");
        this.framesRight[3] = ResourceFactory.get().getSprite("sprites/player/p4.png");
        this.framesLeft[0] = ResourceFactory.get().getSprite("sprites/player/p1.png");
        this.framesLeft[1] = ResourceFactory.get().getSprite("sprites/player/p2.png");
        this.framesLeft[2] = ResourceFactory.get().getSprite("sprites/player/p3.png");
        this.framesLeft[3] = ResourceFactory.get().getSprite("sprites/player/p4.png");
        this.framesSpiderRight[0] = ResourceFactory.get().getSprite("sprites/spider/s1.png");
        this.framesSpiderRight[1] = ResourceFactory.get().getSprite("sprites/spider/s2.png");
        this.framesSpiderRight[2] = ResourceFactory.get().getSprite("sprites/spider/s3.png");
        this.framesSpiderRight[3] = ResourceFactory.get().getSprite("sprites/spider/s4.png");
        this.framesSpiderLeft[0] = ResourceFactory.get().getSprite("sprites/spider/s1.png");
        this.framesSpiderLeft[1] = ResourceFactory.get().getSprite("sprites/spider/s2.png");
        this.framesSpiderLeft[2] = ResourceFactory.get().getSprite("sprites/spider/s3.png");
        this.framesSpiderLeft[3] = ResourceFactory.get().getSprite("sprites/spider/s4.png");
        this.framesSpiderAttackRight[0] = ResourceFactory.get().getSprite("sprites/spider/a1.png");
        this.framesSpiderAttackRight[1] = ResourceFactory.get().getSprite("sprites/spider/a2.png");
        this.framesSpiderAttackRight[2] = ResourceFactory.get().getSprite("sprites/spider/a3.png");
        this.framesSpiderAttackRight[3] = ResourceFactory.get().getSprite("sprites/spider/a4.png");
        this.framesSpiderAttackLeft[0] = ResourceFactory.get().getSprite("sprites/spider/a1.png");
        this.framesSpiderAttackLeft[1] = ResourceFactory.get().getSprite("sprites/spider/a2.png");
        this.framesSpiderAttackLeft[2] = ResourceFactory.get().getSprite("sprites/spider/a3.png");
        this.framesSpiderAttackLeft[3] = ResourceFactory.get().getSprite("sprites/spider/a4.png");
        this.framesMindControl[0] = ResourceFactory.get().getSprite("sprites/player/m1.png");
        this.framesMindControl[1] = ResourceFactory.get().getSprite("sprites/player/m2.png");
        this.framesMindControl[2] = ResourceFactory.get().getSprite("sprites/player/m3.png");
        int i = 0;
        while (i < 4) {
            this.framesSpiderLeft[i].flip();
            this.framesLeft[i].flip();
            this.framesSpiderAttackLeft[i].flip();
            ++i;
        }
    }

    @Override
    public void collidedWith(Entity other) {
        int dir;
        if (other instanceof Block || other instanceof Piston) {
            if (!this.customSize) {
                this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
            } else {
                this.me.setBounds(this.rect.x, this.rect.y, (int)this.rect.getWidth(), (int)this.rect.getHeight());
            }
            if (!other.customSize) {
                this.him.setBounds((int)other.x, (int)other.y, other.sprite.getWidth(), other.sprite.getHeight());
            } else {
                this.him.setBounds(other.rect.x, other.rect.y, (int)other.rect.getWidth(), (int)other.rect.getHeight());
            }
            Rectangle intersection = this.me.intersection(this.him);
            if (intersection.getHeight() > intersection.getWidth()) {
                this.x = intersection.x == this.him.x ? (this.x -= intersection.getWidth()) : (this.x += intersection.getWidth());
            } else {
                this.y = intersection.y == this.him.y ? (this.y -= intersection.getHeight()) : (this.y += intersection.getHeight());
            }
            this.dx *= 0.9;
            this.dy *= 0.9;
        } else if (other instanceof ScreenChanger && ((dir = this.game.currentScreen - ((ScreenChanger)other).screen) >= 1 && this.dx < -1.0 || dir <= -1 && this.dx > 1.0)) {
            this.game.loadScreen(((ScreenChanger)other).screen, ((ScreenChanger)other).playerX, ((ScreenChanger)other).playerY);
        }
    }

    @Override
    public void move(long delta) {
        this.lastFrameChange += delta;
        if (this.hp <= 0) {
            this.game.notifyDeath();
        }
        if (this.mindControlling) {
            if (this.justMindControlled) {
                this.justMindControlled = false;
                Enemy nearestEnemy = this.game.findNearestEnemy(this.x, this.y);
                if (nearestEnemy != null) {
                    double enemyX = nearestEnemy.x;
                    double enemyY = nearestEnemy.y;
                    this.game.entities.remove(nearestEnemy);
                    double playerX = this.x;
                    double playerY = this.y;
                    this.x = enemyX;
                    this.y = enemyY;
                    this.game.shellPlayer.x = playerX;
                    this.game.shellPlayer.y = playerY;
                    this.game.entities.add(this.game.shellPlayer);
                    this.lastFrameChange = 99999L;
                }
            }
            if (this.lastFrameChange > this.frameDuration) {
                if (this.dx > 20.0) {
                    this.lastFrameChange = 0L;
                    ++this.frameNumber;
                    if (this.frameNumber >= this.framesSpiderRight.length) {
                        this.frameNumber = 0;
                    }
                    this.sprite = this.framesSpiderRight[this.frameNumber];
                    this.lastDir = true;
                } else if (this.dx < -20.0) {
                    this.lastFrameChange = 0L;
                    ++this.frameNumber;
                    if (this.frameNumber >= this.framesSpiderLeft.length) {
                        this.frameNumber = 0;
                    }
                    this.sprite = this.framesSpiderLeft[this.frameNumber];
                    this.lastDir = false;
                } else if (this.attacking) {
                    if (this.lastDir) {
                        this.lastFrameChange = 0L;
                        ++this.frameNumber;
                        if (this.frameNumber >= this.framesSpiderAttackRight.length) {
                            this.frameNumber = 0;
                        }
                        this.sprite = this.framesSpiderAttackRight[this.frameNumber];
                    } else {
                        this.lastFrameChange = 0L;
                        ++this.frameNumber;
                        if (this.frameNumber >= this.framesSpiderAttackLeft.length) {
                            this.frameNumber = 0;
                        }
                        this.sprite = this.framesSpiderAttackLeft[this.frameNumber];
                    }
                } else {
                    this.sprite = this.lastDir ? this.framesSpiderRight[0] : this.framesSpiderLeft[0];
                }
            }
        } else if (this.initiatingMindControl) {
            if (this.lastFrameChange > this.frameDuration) {
                this.lastFrameChange = 0L;
                ++this.frameNumber;
                if (this.frameNumber >= this.framesMindControl.length) {
                    this.frameNumber = 0;
                }
                this.sprite = this.framesMindControl[this.frameNumber];
            }
        } else if (this.lastFrameChange > this.frameDuration) {
            if (this.dx > 20.0) {
                this.lastFrameChange = 0L;
                ++this.frameNumber;
                if (this.frameNumber >= this.framesRight.length) {
                    this.frameNumber = 0;
                }
                this.sprite = this.framesRight[this.frameNumber];
                this.lastDir = true;
            } else if (this.dx < -20.0) {
                this.lastFrameChange = 0L;
                ++this.frameNumber;
                if (this.frameNumber >= this.framesLeft.length) {
                    this.frameNumber = 0;
                }
                this.sprite = this.framesLeft[this.frameNumber];
                this.lastDir = false;
            } else {
                this.sprite = this.lastDir ? this.framesRight[0] : this.framesLeft[0];
            }
        }
        this.dy += 9.8 * (double)delta * 0.1;
        this.previusY = this.y;
        this.previusX = this.x;
        super.move(delta);
        this.jumpSquare.setBounds((int)this.x, (int)this.y + 150, 50, 5);
    }
}

