/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.util.Random;

public class Particle
extends Entity {
    int tarX;
    int tarY;
    Game game;
    Random r = new Random();
    int mode = 0;

    public Particle(String ref, Game game, int x, int y, boolean solid, int tarX, int tarY, int explosive) {
        super(ref, x, y, -1, 20, 10, 10, solid);
        this.game = game;
        if (tarX != -1) {
            this.tarX = tarX;
            this.tarY = tarY;
            this.mode = 1;
        } else {
            this.sprite = game.pm.blood[this.r.nextInt(game.pm.blood.length)];
            this.dx += (double)(this.r.nextInt(50 * explosive) - 25 * explosive);
            this.dy += (double)(this.r.nextInt(50 * explosive) - 25 * explosive);
        }
    }

    @Override
    public void collidedWith(Entity other) {
        if (this.mode == 0 && other instanceof Block || other instanceof Piston) {
            if (!this.customSize) {
                this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
            } else {
                this.me.setBounds(this.rect.x, this.rect.y, (int)this.rect.getWidth(), (int)this.rect.getHeight());
            }
            if (!other.customSize) {
                this.him.setBounds((int)other.x, (int)other.y, other.sprite.getWidth(), other.sprite.getHeight());
            } else {
                this.him.setBounds(other.rect.x, other.rect.y, (int)other.rect.getWidth(), (int)other.rect.getHeight());
            }
            Rectangle intersection = this.me.intersection(this.him);
            if (intersection.getHeight() > intersection.getWidth()) {
                this.x = intersection.x == this.him.x ? (this.x -= intersection.getWidth()) : (this.x += intersection.getWidth());
            } else {
                this.y = intersection.y == this.him.y ? (this.y -= intersection.getHeight()) : (this.y += intersection.getHeight());
            }
            this.dx *= 0.9;
            this.dy *= 0.9;
        }
    }

    @Override
    public void move(long delta) {
        if (this.mode == 0) {
            this.dy += 9.8;
        } else if (this.mode == 1) {
            double dirX = (double)this.tarX - this.x;
            double dirY = (double)this.tarY - this.y;
            double nDirX = Util.normaliseX(dirX, dirY);
            double nDirY = Util.normaliseY(dirX, dirY);
            if (Util.distBetween(this.x, this.y, this.tarX, this.tarY) > 10.0) {
                this.dx = (double)delta * (nDirX * 50.0 + (double)(this.r.nextInt(10) - 5));
                this.dy = (double)delta * (nDirY * 50.0 + (double)(this.r.nextInt(10) - 5));
            } else {
                this.game.removeEntity(this);
            }
        }
        super.move(delta);
    }
}

