/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

public abstract class Entity {
    protected double x;
    protected double y;
    public Sprite sprite;
    protected double dx;
    protected double dy;
    public Rectangle me = new Rectangle();
    public Rectangle him = new Rectangle();
    public boolean customSize = false;
    public Rectangle rect = new Rectangle();
    boolean solid = false;

    public Entity(String ref, int x, int y, int rx, int ry, int rw, int rh, boolean solid) {
        this.solid = solid;
        this.sprite = ResourceFactory.get().getSprite(ref);
        this.x = x;
        this.y = y;
        if (rx != -1) {
            this.setBounds(x + rx, y + ry, rw, rh);
        }
    }

    public void setBounds(int rx, int ry, int rw, int rh) {
        this.customSize = true;
        this.rect.setBounds(rx, ry, rw, rh);
    }

    public void move(long delta) {
        this.x += (double)delta * this.dx / 1000.0;
        this.y += (double)delta * this.dy / 1000.0;
    }

    public boolean isCustomSize() {
        return this.customSize;
    }

    public boolean isStill() {
        return this.dx > -1.0 && this.dx < 1.0;
    }

    public void setHorizontalMovement(double dx) {
        this.dx = dx;
    }

    public void setVerticalMovement(double dy) {
        this.dy = dy;
    }

    public double getHorizontalMovement() {
        return this.dx;
    }

    public double getVerticalMovement() {
        return this.dy;
    }

    public void draw() {
        this.sprite.draw((int)this.x, (int)this.y);
    }

    public void doLogic() {
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public void setPos(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean collidesWith(Entity other) {
        if (!this.customSize) {
            this.me.setBounds((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
        } else {
            this.me.setBounds(this.rect.x, this.rect.y, (int)this.rect.getWidth(), (int)this.rect.getHeight());
        }
        if (!other.customSize) {
            this.him.setBounds((int)other.x, (int)other.y, other.sprite.getWidth(), other.sprite.getHeight());
        } else {
            this.him.setBounds(other.rect.x, other.rect.y, (int)other.rect.getWidth(), (int)other.rect.getHeight());
        }
        return this.me.intersects(this.him);
    }

    public abstract void collidedWith(Entity var1);
}

